-- Exemplo
-- segmentos do mostrador ativo nivel baixo   (vide tabela Ap.2.1)
-- segmento  pino_mostrador_h  pino_mostrador_l   
--  a = 0           6               17            a
--  b = 1           7               18          ---- 
--  c = 2           8               19        f|    |b
--  d = 3           9               20         |  g |
--  e = 4          11               21          ----
--  f = 5          12               23        e|    |c
--  g = 6          13               24         |  d |  
--  ponto = 7      14               25          ---- . ponto

--  oscilador de 25.175Mhz  (vide tabela Ap.2.2)
--  pino 91

-- chaves de contato momentaneo  (vide tabela Ap.2.3)
-- flex_pb1  pino 28
-- flex_pb2  pino 29

-- chaves dip-switch 0-1   (vide tabela Ap.2.4)
-- flex_sw1  1  2  3  4  5  6  7  8
-- pino     41 40 39 38 36 35 34 33

ENTITY t_placa2 IS
  GENERIC (max_h        : INTEGER  := 5;           -- valor maximo mostrador H
           max_l        : INTEGER  := 9;           -- valor maximo  mostrador L
           div_por      : INTEGER  := 16777216);   -- divide 25.175MHz by 2**24
  PORT   (ck             : IN  BIT;                   -- base de tempo (relogio)
          reset_b        : IN  BIT;                   -- reset_b=0 inicializa maquina
          seg_h          : OUT BIT_VECTOR (0 TO 7);   -- mostrador H
          seg_l          : OUT BIT_VECTOR (0 TO 7));  -- mostrador L
END t_placa2;

ARCHITECTURE bit_type OF t_placa2 IS
  SIGNAL ct_h       : INTEGER RANGE    max_h  DOWNTO 0;       -- contador mostrador_h
  SIGNAL ct_l       : INTEGER RANGE    max_l  DOWNTO 0;       -- contador mostrador_l
  SIGNAL dv         : INTEGER RANGE    div_por DOWNTO 0;      -- base de tempo interna
--                           segmento mostrador:  abcdefgh    -- '0' ativa o segmento
  CONSTANT ds0      : BIT_VECTOR (7 DOWNTO 0) := "00000011";  -- codigo numero 0
  CONSTANT ds1      : BIT_VECTOR (7 DOWNTO 0) := "10011111";  -- codigo numero 1
  CONSTANT ds2      : BIT_VECTOR (7 DOWNTO 0) := "00100101";  -- codigo numero 2
  CONSTANT ds3      : BIT_VECTOR (7 DOWNTO 0) := "00001101";  -- codigo numero 3
  CONSTANT ds4      : BIT_VECTOR (7 DOWNTO 0) := "10011001";  -- codigo numero 4
  CONSTANT ds5      : BIT_VECTOR (7 DOWNTO 0) := "01001001";  -- codigo numero 5
  CONSTANT ds6      : BIT_VECTOR (7 DOWNTO 0) := "01000001";  -- codigo numero 6
  CONSTANT ds7      : BIT_VECTOR (7 DOWNTO 0) := "00011111";  -- codigo numero 7
  CONSTANT ds8      : BIT_VECTOR (7 DOWNTO 0) := "00000001";  -- codigo numero 8
  CONSTANT ds9      : BIT_VECTOR (7 DOWNTO 0) := "00001001";  -- codigo numero 9
  CONSTANT dsn      : BIT_VECTOR (7 DOWNTO 0) := "11111111";  -- apagado

BEGIN
count: PROCESS (ck, reset_b) 
  BEGIN
    IF (reset_b ='0') THEN            -- reset assincrono
        ct_h <= 0;
        ct_l <= 0;
        dv <= 0; 
    ELSIF (ck'EVENT) AND (ck = '1') THEN -- base de tempo externa
      IF (dv = div_por -1) THEN          -- teste fim da divisao do sinal ck
        dv <= 0;                         -- zera contador incrementa dv
        IF (ct_l = max_l) THEN           -- teste fim da contagem digit_l
          ct_l <= 0;                     -- zera contador ct_l caso ct_l = max_l
          IF (ct_h = max_h) THEN ct_h <= 0;       -- teste fim da contagem digit_h 
          ELSE                   ct_h <= ct_h +1; -- continua contagem digit_h                   
          END IF;
        ELSE   ct_l <= ct_l +1;                   -- continua contagem digit_l                  
        END IF;
      ELSE                                -- continua divisao do sinal ck
        dv <= dv +1;
      END IF; -- div_por
    END IF;
  END PROCESS count;

table_h: BLOCK
  BEGIN
    seg_h <= dsn WHEN ct_h = 0 ELSE   -- mostrador mais significativo apagado quando '0'
             ds1 WHEN ct_h = 1 ELSE
             ds2 WHEN ct_h = 2 ELSE
             ds3 WHEN ct_h = 3 ELSE
             ds4 WHEN ct_h = 4 ELSE
             ds5 WHEN ct_h = 5 ELSE
             ds6 WHEN ct_h = 6 ELSE
             ds7 WHEN ct_h = 7 ELSE
             ds8 WHEN ct_h = 8 ELSE
             ds9;
  END BLOCK table_h;

table_l: BLOCK
  BEGIN
    seg_l <= ds0 WHEN ct_l = 0 ELSE
             ds1 WHEN ct_l = 1 ELSE
             ds2 WHEN ct_l = 2 ELSE
             ds3 WHEN ct_l = 3 ELSE
             ds4 WHEN ct_l = 4 ELSE
             ds5 WHEN ct_l = 5 ELSE
             ds6 WHEN ct_l = 6 ELSE
             ds7 WHEN ct_l = 7 ELSE
             ds8 WHEN ct_l = 8 ELSE
             ds9;
  END BLOCK table_l;

END bit_type;
