ENTITY cas_sel6 IS 
  GENERIC (gen : INTEGER := 7);
  PORT (bt     : IN  BIT;
        btv    : IN  BIT_VECTOR(2 DOWNTO 0); 
        bol    : IN  BOOLEAN;
        chr    : IN  CHARACTER;
        int    : IN  INTEGER;
        rl     : IN  REAL;
        st     : IN  STRING(1 TO 3);
        tm     : IN  TIME;
        o0,o1,o2,o3,o4,o5,o6,o7,o8, o9 : OUT INTEGER);
END cas_sel6;

ARCHITECTURE teste OF cas_sel6 IS
  CONSTANT cst : INTEGER := 7;
BEGIN
  PROCESS(bt, btv, bol, chr, int, rl, st, tm)
  BEGIN
  CASE bt IS 
    WHEN   '0'  => o0 <= 0;  
    WHEN OTHERS => o0 <= 1;
  END CASE;
  
  CASE btv IS 
    WHEN "000"  => o1 <= 0;  
    WHEN OTHERS => o1 <= 1;
  END CASE;

  CASE bol IS 
    WHEN FALSE  => o2 <= 0;  
    WHEN OTHERS => o2 <= 1;
  END CASE;
            
  CASE chr IS 
    WHEN 'a'    => o3 <= 0;  
    WHEN OTHERS => o3 <= 1;
  END CASE;

  CASE int IS 
    WHEN   7    => o4 <= 0;  
    WHEN OTHERS => o4 <= 1;
  END CASE;
  
  CASE rl IS                     
    WHEN  7.0   => o5 <= 0;        
    WHEN OTHERS => o5 <= 1;
  END CASE;
      
  CASE st IS 
    WHEN  "abc" => o6 <= 0;       
    WHEN OTHERS => o6 <= 1;
  END CASE;

  CASE tm IS                     
    WHEN  50 ns => o7 <= 0;      
    WHEN OTHERS => o7 <= 1;
  END CASE;  

  CASE int IS 
    WHEN  gen   => o8 <= 0;     
    WHEN OTHERS => o8 <= 1;
  END CASE;    
   
  CASE int IS 
    WHEN  cst   => o9 <= 0;      
    WHEN OTHERS => o9 <= 1;
  END CASE;  
  END PROCESS;           
END teste;
