ENTITY atr_usua4 IS
  PORT (clk_ext, rst_ext, set_ext : IN  BIT);  -- sinais externos
END atr_usua4;

ARCHITECTURE teste OF atr_usua4 IS
  SIGNAL  clk, rst, set  : BIT;    -- sinais que serao definidos atributos
  
  -- atributo: tempo de propagacao de nivel baixo para nivel alto: ____/----      
  ATTRIBUTE tempo_lh : TIME;                      -- declaracao do atributo: tempo_lh
  ATTRIBUTE tempo_lh OF clk    : SIGNAL IS 20 ns; -- atributo do item ck
  ATTRIBUTE tempo_lh OF OTHERS : SIGNAL IS 30 ns; -- atributo dos itens restantes: rst e set
  
  -- atributo: tempo de propagacao de nivel alto para nivel baixo: ----\____    
  ATTRIBUTE tempo_hl : TIME;                     -- declaracao do atributo: tempo_hl
  ATTRIBUTE tempo_hl OF ALL : SIGNAL IS 10 ns;   -- atributo de todos itens: clk, rst e set
 
BEGIN                             --    (_____/------  subida de clk_ext)
  clk <= clk_ext AFTER clk'tempo_lh WHEN(clk_ext'EVENT AND clk_ext = '1') ELSE 
         clk_ext AFTER clk'tempo_hl;
                                  --    (_____/------  subida de rst_ext)
  rst <= rst_ext AFTER rst'tempo_lh WHEN(rst_ext'EVENT AND rst_ext = '1') ELSE 
         rst_ext AFTER rst'tempo_hl;
                                  --    (_____/------  subida de set_ext)
  set <= set_ext AFTER set'tempo_lh WHEN(set_ext'EVENT AND set_ext = '1') ELSE
         set_ext AFTER set'tempo_hl;                
END teste;