ENTITY flip3_4 IS
  PORT (ck        : IN  BIT;     -- relogio
        enb       : IN  BIT;     -- habilita sinal de relogio
        rst, set  : IN  BIT;     -- rst=1 q=000, set=1 q=111 assincronos
        d    : IN  BIT_VECTOR(2 DOWNTO 0);
        q    : OUT BIT_VECTOR(2 DOWNTO 0));    
END flip3_4;

ARCHITECTURE teste OF flip3_4 IS
BEGIN
  PROCESS (ck, rst, set)
  BEGIN
    IF    (rst = '1') THEN q <= "000";   -- q=000 independente de ck
    ELSIF (set = '1') THEN q <= "111";   -- q=111 independente de ck 
    ELSIF (ck'EVENT AND ck = '1') THEN   -- detecta borda de ck
      IF  (enb = '1') THEN q <= d;       -- verifica habilitacao
      END IF;
    END IF;
  END PROCESS;
END teste;