ENTITY maq_est2 IS
  PORT (ck      :  IN     BIT;                      -- relogio borda subida
        sobe    :  IN     BIT;                      -- sobe=1, q=00,01,11,10,00...
        iniciar :  IN     BIT;                      -- iniciar=1, q=00
        q       :  OUT    BIT_VECTOR (1 DOWNTO 0)); -- saida
END maq_est2;

ARCHITECTURE teste OF maq_est2 IS
  --           q=2     q=3     q=1     q=0 
  TYPE st IS (caso_d, caso_c, caso_b, caso_a);  -- novo tipo definido
  SIGNAL estado : st;                           -- sinal estado tipo "st"
BEGIN
  abc: PROCESS (ck, iniciar)
  BEGIN
    IF iniciar = '1' THEN                 -- estado inicial
      estado <= caso_a;                   -- q=0
    ELSIF (ck'EVENT and ck ='1') THEN     -- ciclo de estados
      CASE estado IS
        WHEN caso_a =>                          -- q=0
          IF sobe = '1' THEN estado <= caso_b;  -- q=1
          ELSE               estado <= caso_d;  -- q=2 
          END IF;
        WHEN caso_b =>                          -- q=1
          IF sobe = '1' THEN estado <= caso_c;  -- q=3
          ELSE               estado <= caso_a;  -- q=0
          END IF;
        WHEN caso_c =>                          -- q=3
          IF sobe = '1' THEN estado <= caso_d;  -- q=2
          ELSE               estado <= caso_b;  -- q=1
          END IF;
        WHEN caso_d =>                          -- q=2
          IF sobe = '1' THEN estado <= caso_a;  -- q=0
          ELSE               estado <= caso_c;  -- q=3
          END IF;
       END CASE;
    END IF;
  END PROCESS abc;

  WITH estado SELECT   -- decodifica estado
    q <= "00" WHEN caso_a, -- q=0
         "01" WHEN caso_b, -- q=1
         "11" WHEN caso_c, -- q=3
         "10" WHEN caso_d; -- q=2
END teste;
