ENTITY gen_3x IS
  GENERIC (tp_ex : TIME := 21 ns);
  PORT  (x  : IN  BIT_VECTOR (3 DOWNTO 0);  
         s  : OUT BIT_VECTOR (3 DOWNTO 0));
END gen_3x;

ARCHITECTURE estrutural OF gen_3x IS
  COMPONENT gen_1a  -- lista de associacoes: generico com valor inicial   (equivalente ao caso 1)
    GENERIC (tp : TIME := 14 ns);
    PORT    (a : IN  BIT;  s : OUT BIT); 
  END COMPONENT;
  
   COMPONENT gen_1b  -- lista de associacoes: generico com valor inicial  (equivalente ao caso 2)
    GENERIC (tp : TIME := 14 ns);
    PORT    (a : IN  BIT;  s : OUT BIT); 
  END COMPONENT;
  
  COMPONENT gen_1c  -- sem lista de associacao de generico                (equivalente ao caso 3)
    PORT    (a : IN  BIT;  s : OUT BIT); 
  END COMPONENT;
  
  COMPONENT gen_1d  -- lista de associacoes: generico sem valor inicial   (equivalente ao caso 4)
    GENERIC (tp : TIME);
    PORT    (a : IN  BIT;  s : OUT BIT); 
  END COMPONENT;
BEGIN
  x0: gen_1a GENERIC MAP(tp_ex) PORT MAP(x(0), s(0)); -- valor empregado =21ns
  x1: gen_1b                    PORT MAP(x(1), s(1)); -- valor empregado =14ns
  x2: gen_1c                    PORT MAP(x(2), s(2)); -- valor empregado =7ns
  x3: gen_1d GENERIC MAP(3 ns)  PORT MAP(x(3), s(3)); -- valor empregado =3ns 
END estrutural;