LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;

ENTITY std1076g IS
  PORT (xs     : IN     SIGNED (3 DOWNTO 0);
        ys     : IN     SIGNED (3 DOWNTO 0);
        s_add  : BUFFER SIGNED (3 DOWNTO 0);
        s_tras : OUT    STD_LOGIC);  
END std1076g;

ARCHITECTURE teste OF std1076g IS
  SIGNAL teste : STD_LOGIC_VECTOR(2 DOWNTO 0);
BEGIN
  s_add <= xs + ys;
  
  teste <= xs(3) & ys(3) & s_add(3);
  WITH teste SELECT                    -- decodificador
    s_tras <= '1' WHEN "001" | "110",  -- condicoes de transbordo
              '0' WHEN OTHERS;         -- resultado correto 
END teste;