LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;

ENTITY std1076w IS
  PORT (ck, rst  : IN  STD_LOGIC;                     
        q        : OUT STD_LOGIC_VECTOR(3 DOWNTO 0));
END std1076w;

ARCHITECTURE teste OF std1076w IS
  SIGNAL q_uns : UNSIGNED(3 DOWNTO 0);
BEGIN
  abc: PROCESS (ck, rst)
  BEGIN
    IF rst = '1' THEN q_uns <= "0000"; 
    ELSIF rising_edge(ck) THEN   
      IF q_uns /= 10 THEN q_uns <= q_uns +1;
      ELSE                q_uns <= "0000";
      END IF;
    END IF;
  END PROCESS abc;
  
  converte: FOR i IN 0 TO 3 GENERATE
    q(i) <= q_uns(i);
  END GENERATE converte;
END teste;




