LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;

ENTITY std_sft IS
  PORT (ck, ld   :  IN     STD_LOGIC;  
        d1, d2   :  IN     UNSIGNED (4 DOWNTO 0); 
        q1, q2   :  BUFFER UNSIGNED (4 DOWNTO 0));
END std_sft;

ARCHITECTURE teste OF std_sft IS
BEGIN
  abc: PROCESS (ck)
  BEGIN
    IF rising_edge(ck) THEN   
      IF ld = '1' THEN 
        q1 <= d1;
        q2 <= d2;
      ELSE             
        q1(q1'LENGTH-1 DOWNTO 0) <= q1(q1'LENGTH-2 DOWNTO 0) & '0';
        q2 <= shift_left(q2, 1);   
      END IF;
    END IF;
  END PROCESS abc;
END teste;