LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;

ENTITY ram_1 IS
   PORT (dado_entrada : IN  UNSIGNED(3 DOWNTO 0);
         dado_saida   : OUT UNSIGNED(3 DOWNTO 0);
         endereco     : IN  UNSIGNED(2 DOWNTO 0);         
         we, ce       : IN  STD_LOGIC);
END ram_1;

ARCHITECTURE teste OF ram_1 IS
  TYPE   arranjo_memoria IS ARRAY(0 TO 7) OF UNSIGNED(3 DOWNTO 0);
  SIGNAL memoria : arranjo_memoria;
BEGIN
  PROCESS(ce, endereco)
  BEGIN
    IF rising_edge(ce) THEN   -- dado armazenado na subida de "ce" com "wr=0"
      IF we = '0' THEN  memoria(to_integer(endereco)) <= dado_entrada;
      END IF;
   END IF;
   END PROCESS;
   dado_saida <= memoria(to_integer(endereco));
END teste;