LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;

ENTITY rom_1 IS
  PORT(endereco : IN  UNSIGNED(3 DOWNTO 0); -- valores de 0 a 15
       ce       : IN  STD_LOGIC;            -- habitita memoria
       saida    : OUT UNSIGNED(7 DOWNTO 0));-- saida de dados da memoria
END rom_1 ;

ARCHITECTURE teste OF rom_1 IS
  TYPE     arranjo_memoria IS ARRAY (NATURAL RANGE <>) OF UNSIGNED(7 DOWNTO 0);
  CONSTANT dados : arranjo_memoria(0 TO 15) :=
  ("00000011","10011111","00100101","00001101","10011000", -- valores posicoes 0,1,2,3,4
   "01001001","01000001","00011111","00011001","00001001", -- valores posicoes 5,6,7,8,9
   "01001001","01000001","00010111","00000001","01001001","01000110"); -- posicoes restantes
BEGIN
  saida <= dados(to_integer(endereco)) WHEN ce='0' ELSE (OTHERS=>'Z');
END teste;