ENTITY teste_e1 IS  
END teste_e1;
  
ARCHITECTURE teste OF teste_e1 IS
  TYPE vetor_2d  IS ARRAY (0 TO 7) OF BIT_VECTOR(3 DOWNTO 0);
  TYPE vetor_3d  IS ARRAY (0 TO 2) OF vetor_2d;

  SIGNAL   s_2d, t_2d: vetor_2d;
  CONSTANT c_2d: vetor_2d := (0 TO 2 =>('0','0','0','0'), OTHERS => ('1','0','1','1'));
  SIGNAL   s_3d, t_3d: vetor_3d;

BEGIN
  s_2d(7)(2) <= c_2d(7)(1);                   -- 1 elemento
  s_2d(3) <= "1000";                          -- 1 indice
  s_2d(4 TO 6) <= ("1010", OTHERS => "1011"); -- faixa de indices
  s_2d(0 TO 2) <= c_2d(3 TO 5);               -- faixa de indices
  t_2d <= c_2d;                               -- vetor completo
  
  s_3d(2)(7)(3) <= c_2d(7)(1);                   -- 1 elemento
  s_3d(0)(1)(2 DOWNTO 0) <= c_2d(3)(3 DOWNTO 1); -- faixa
  s_3d(1)(2 TO 3) <= c_2d(5 TO 6);
  t_3d(2) <= c_2d;                               -- faixa
  t_3d(0 TO 1) <= c_2d & c_2d;                   -- faixa
END teste;