ENTITY teste_g1 IS 
END teste_g1;  

ARCHITECTURE teste OF teste_g1 IS
  TYPE vetor_2d  IS ARRAY (0 TO 7) OF BIT_VECTOR(3 DOWNTO 0);
  TYPE vetor_3dm IS ARRAY (0 TO 2, 0 TO 7) OF BIT_VECTOR(3 DOWNTO 0);  
  CONSTANT c_2d: vetor_2d := (0 TO 2 =>('0','0','0','0'), OTHERS => ('1','0','1','1'));
  SIGNAL   s_3d, t_3d: vetor_3dm;
  
BEGIN
--s_3d(2)(7)(3) <= c_2d(7)(1);                   -- 1 elemento
  s_3d(2,7)(3)  <= c_2d(7)(1);                   -- 1 elemento

--s_3d(0)(1)(2 DOWNTO 0) <= c_2d(3)(3 DOWNTO 1); -- faixa
  s_3d(0,1)(2 DOWNTO 0)  <= c_2d(3)(3 DOWNTO 1); -- faixa  

--s_3d(1)(2 TO 3) <= c_2d(5 TO 6);               -- faixa
  s_3d(1,2)       <= c_2d(5);
  s_3d(1,3)       <= c_2d(6);

--t_3d(2) <= c_2d;                               -- faixa
  abc: FOR i IN 0 TO 7 GENERATE
    t_3d(2,i) <= c_2d(i);
  END GENERATE;  

--  t_3d(0 TO 1) <= c_2d & c_2d;                   -- faixa
  def: FOR n IN 0 TO 1 GENERATE
    ghi: FOR i IN 0 TO 7 GENERATE
      t_3d(n,i) <= c_2d(i);
    END GENERATE;
  END GENERATE;
END teste;