-- versao VHDL-1993
USE STD.TEXTIO.ALL;

ENTITY arqv_e1 IS
  PORT(dado  : OUT CHARACTER);  -- caracteres recuperados no arquivo
END arqv_e1;

ARCHITECTURE teste OF arqv_e1 IS
   FILE arq_wr_rd : TEXT;
 BEGIN
  escreve_le: PROCESS
    VARIABLE linha      : LINE;             -- objeto tipo LINE para armazenar texto
    VARIABLE leitura_ok : BOOLEAN := TRUE;  -- verificacao do procedimento READ
    VARIABLE valor      : CHARACTER;        -- dado recuperado no arquivo
  BEGIN
    FILE_OPEN(arq_wr_rd, "/vhdl/dado_e1.dat",Write_Mode);
    FOR ch IN 'a' TO 'z' LOOP
      WRITE(linha, ch);                  -- esqueve valores na linha   
    END LOOP;                            -- 
    WRITELINE (arq_wr_rd, linha);        -- armazena no arquivo
    FILE_CLOSE(arq_wr_rd);               -- fecha o arquivo
 
    FILE_OPEN(arq_wr_rd, "/vhdl/dado_e1.dat",Read_Mode);
    READLINE (arq_wr_rd, linha);         -- leitura de uma linha
    WHILE leitura_ok LOOP               
      READ (linha, valor, leitura_ok);   -- leitura dos dados de uma linha
      dado <= valor;
      WAIT FOR 10 ns;                    -- temporizacao para mostra "dado" no simulador
    END LOOP;
    FILE_CLOSE(arq_wr_rd);               -- fecha o arquivo                        
    WAIT;
  END PROCESS escreve_le;
END teste;