-- versao VHDL-1987
-- termine a execucao da simulacao para fechar arquivo
ENTITY arqv_k IS
  GENERIC(n : INTEGER := 7);
  PORT(dado_lido  : OUT STRING(1 TO n);
       tamanho    : OUT NATURAL);       -- valor retornado do procedimento READ
END arqv_k;

ARCHITECTURE teste OF arqv_k IS
  -- informacao contida no arquivo = abcdefghijklmnopqrstuvxz
  TYPE arquivo IS FILE OF STRING;      -- limites do vetor nao definidos
  FILE arq_wr_rd : arquivo IS IN "/vhdl/dado_g.dat";
 BEGIN
  escreve_le: PROCESS
    VARIABLE dado_lido_v : STRING(1 TO n);
    VARIABLE tamanho_v : NATURAL;
  BEGIN
    WHILE NOT ENDFILE(arq_wr_rd) LOOP          -- testa fim do arquivo
      READ(arq_wr_rd, dado_lido_v, tamanho_v); -- le os valores na forma binaria
      dado_lido <= dado_lido_v;                -- argumento do procedimento tipo variavel
      tamanho <= tamanho_v;
      WAIT FOR 10 ns;                          -- aguarda 10 ns para proxima leitura
    END LOOP;                          
  WAIT;
  END PROCESS escreve_le;
END teste;