-- arquivo conf_1.vhd
-- Especificacao da configuracao 
ENTITY somadores1 IS
  PORT (x,  y  : IN  INTEGER RANGE 0 TO 7;
        sl, st, sr : OUT INTEGER RANGE 0 TO 15);    
END somadores1;

ARCHITECTURE teste OF somadores1 IS
--         "add": nome_local do componente -- intefaces com mesma designacao
  COMPONENT add PORT (a, b : IN  INTEGER RANGE 0 TO 7; s : OUT INTEGER RANGE 0 TO 15);
  END COMPONENT;
  
--         "adx": nome_local do componente -- interfaces com designacao diferente
  COMPONENT adx PORT (k, l : IN  INTEGER RANGE 0 TO 7; m : OUT INTEGER RANGE 0 TO 15);
  END COMPONENT;  
  
-- associacao entre "add" e "adx" e as entidades de projeto "soma"  
  FOR u1 : add USE ENTITY WORK.soma;         -- aquitetura = ultima compilada
  FOR u2 : add USE ENTITY WORK.soma(lenta);
  FOR u3 : adx USE ENTITY WORK.soma(tipica) PORT MAP(a => k, b =>l, s => m); 
BEGIN
  u1 : add PORT MAP(x, y, sr);
  u2 : add PORT MAP(x, y, sl);
  u3 : adx PORT MAP(x, y, st);
END teste;