-- arquivo conf_e1.vhd

-- Unidade nivel mais baixo
ENTITY xor_1 IS PORT (x1,  y1  : IN  BIT; s1  : OUT BIT);    
END xor_1;
ARCHITECTURE baixa OF xor_1 IS
BEGIN
  s1 <= x1 XOR y1;
END baixa;

-- Unidade nivel intermediario. 
-- Referencia entidade "local_xor_1", necessita de configuracao para criar elo com "xor_1"
ENTITY xor_2 IS PORT (x2, y2, z2 : IN BIT; s2  : OUT BIT);
END xor_2;        
ARCHITECTURE media OF xor_2 IS
  COMPONENT local_xor_1 PORT(x1, y1 : IN BIT; s1 : OUT BIT); END COMPONENT; 
  SIGNAL k2 : BIT;
BEGIN 
  u1 : local_xor_1  PORT MAP(x2, y2, k2);  -- criar elo com "xor_1"
  u2 : local_xor_1  PORT MAP(z2, k2, s2);  -- criar elo com "xor_1"
END media;

-- Unidade nivel mais alto. 
-- Referencia entidade "local_xor_2", necessita configuracao para criar elo com "xor_2"
ENTITY xor_3 IS PORT (x3, y3, z3, k3 : IN BIT; s3 : OUT BIT);
END xor_3;

ARCHITECTURE alta OF xor_3 IS
  COMPONENT local_xor_2 PORT (x2, y2, z2 : IN BIT; s2  : OUT BIT); END COMPONENT;
  SIGNAL t3 : BIT; 
BEGIN
  m1 : local_xor_2 PORT MAP(x3, y3, z3, t3);  -- criar elo com "xor_2"
  s3 <= t3 OR k3;
END alta;  