PACKAGE dre_ab_c IS
  TYPE U_aberto IS ('H','0');                                  -- tipo sem funcao de resolucao 
  TYPE U_aberto_vetor IS ARRAY (NATURAL RANGE <>) OF U_aberto; -- tipo sem funcao de resolucao
  
  FUNCTION resolver(a : U_aberto_vetor) RETURN U_aberto;      -- funcao de resolucao
  SUBTYPE  R_aberto IS resolver U_aberto;                     -- tipo com funcao de resolucao
  
  TYPE resolve_aberto IS ARRAY (U_aberto, U_aberto) OF U_aberto; 
  CONSTANT tabela : resolve_aberto :=
 -- ordem na tabela: do indice de menor valor para indice de maior valor (H para 0)
 --  H    0           
  (('H', '0'),  -- H
   ('0', '0')); -- 0
END dre_ab_c;

PACKAGE BODY dre_ab_c IS
   FUNCTION resolver(a : U_aberto_vetor) RETURN U_aberto IS
     VARIABLE final : R_aberto := 'H';
   BEGIN
     FOR i IN a'RANGE LOOP
       final := tabela(final,a(i)); -- valor extraido da tabela
     END LOOP;
     RETURN final;
   END resolver;
END dre_ab_c;