ENTITY reg_uso IS
  GENERIC (k : INTEGER := 3);
  PORT (controle, reset: IN BIT; dado : IN BIT_VECTOR(k DOWNTO 0);
        saida_l, saida_f : OUT BIT_VECTOR(k DOWNTO 0));
END reg_uso;

ARCHITECTURE topo OF reg_uso IS
COMPONENT latch 
  GENERIC (k : INTEGER := k);
  PORT (en, rst: IN  BIT; d: IN BIT_VECTOR(k DOWNTO 0); q: OUT BIT_VECTOR(k DOWNTO 0));    
END COMPONENT;

COMPONENT flipflop 
  GENERIC (k : INTEGER);  -- necessita mapa de generico
  PORT (ck, rst: IN  BIT; d: IN BIT_VECTOR(k DOWNTO 0); q: OUT BIT_VECTOR(k DOWNTO 0));    
END COMPONENT;

BEGIN
  u1 : latch                   PORT MAP(controle, reset, dado, saida_l);
  u2 : flipflop GENERIC MAP(k) PORT MAP(controle, reset, dado, saida_f);
END topo;
