-- VHDL 1993
ENTITY forma_1 IS
  GENERIC(t_ck   : TIME := 30 ns;                          -- sinal s0
          t_alto : TIME := 10 ns; t_baixo : TIME := 20 ns; -- sinais s1 e s2
          t_rol  : TIME := 10 ns);                         -- sinal s3
  PORT (s0, s1, s2, s3  : BUFFER BIT);
END forma_1;

ARCHITECTURE teste OF forma_1 IS
  SIGNAL dado : BIT_VECTOR(2 DOWNTO 0) := "001";
BEGIN                                          --               _____       ____
  s0 <= NOT s0 AFTER t_ck/2;                   --   s0     ____|     |_____|    |
  
  s1 <= NOT s1 AFTER t_baixo WHEN s1 ='0' ELSE
        NOT s1 AFTER t_alto;                   --                 ___        ___
                                               -- s1 s2 s3 ______|   |______|   |
  s2 <= '0' AFTER t_alto  WHEN s2 ='1' ELSE
        '1' AFTER t_baixo;

  dado <= dado ROL 1 AFTER t_rol;
  s3 <= dado(2);
END teste;