-- VHDL 1993
ENTITY forma_2c IS
  GENERIC(t_ck   : TIME := 30 ns;                          -- sinal s0
          t_alto : TIME := 10 ns; t_baixo : TIME := 20 ns; -- sinais s1 e s2
          t_rol  : TIME := 10 ns);                         -- sinal s3
  PORT (s0, s1, s2, s3  : BUFFER BIT := '0');              -- Note: valor inicial =0
END forma_2c;

ARCHITECTURE teste OF forma_2c IS
  SIGNAL dado : BIT_VECTOR(2 DOWNTO 0) := "001";
BEGIN
  abc: PROCESS BEGIN
    WAIT FOR t_ck/2; s0 <= NOT s0; 
  END PROCESS;
  
  def: PROCESS BEGIN
    WAIT FOR t_baixo; s1 <= NOT s1;
    WAIT FOR t_alto; s1 <= NOT s1;
  END PROCESS;

  ghi: PROCESS BEGIN
    s2 <= '0'; WAIT FOR t_baixo; 
    s2 <= '1'; WAIT FOR t_alto; 
  END PROCESS;  

  jkl: PROCESS BEGIN
    dado <= dado ROL 1; s3 <= dado(2); WAIT FOR t_rol;
  END PROCESS;
END teste;