ENTITY forma_5 IS
  PORT (s0, s1  : OUT BIT_VECTOR(1 DOWNTO 0);
        n0, n1  : OUT INTEGER);
END forma_5;

ARCHITECTURE teste OF forma_5 IS
  TYPE sinais IS 
    RECORD nt : INTEGER;
           dt : BIT_VECTOR(1 DOWNTO 0);
    END RECORD;
 TYPE conjunto_sinais IS ARRAY (natural RANGE <>) OF sinais;
 CONSTANT vet : conjunto_sinais := ((1,"01"),(3,"11"),(2,"10"),(0,"00"));

BEGIN
-- valor atribuido em:
--          t=0ns  t=20 ns                t=50 ns                t=100ns                                                  
  s0 <= vet(0).dt, vet(1).dt AFTER 20 ns, vet(2).dt AFTER 70 ns, vet(3).dt AFTER 100 ns;
  n0 <= vet(0).nt, vet(1).nt AFTER 20 ns, vet(2).nt AFTER 70 ns, vet(3).nt AFTER 100 ns;
   
  abc: PROCESS BEGIN                   -- iteracao ocorre na execucao da decl. WAIT
    s1 <= vet(0).dt; n1 <= vet(0).nt; 
    WAIT FOR 20 ns;                    -- s1 =01, n1=1 em 0ns,     e aguarda 20ns 
    s1 <= vet(1).dt; n1 <= vet(1).nt;
    WAIT FOR 50 ns;                    -- s1 =11, n1=3 em 0+20ns,  e agurada 50ns
    s1 <= vet(2).dt; n1 <= vet(2).nt;
    WAIT FOR 30 ns;                    -- s1 =10, n1=2 em 20+50ns, e agurada 30ns
    s1 <= vet(3).dt; n1 <= vet(3).nt;
    WAIT;                              -- s1 =00, n1=0 em 70+30ns, e para
  END PROCESS;
END teste;