-- versao VHDL-1993
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY tes_t0 IS
  PORT (ck_t, rst_t : BUFFER STD_LOGIC;
        d_t, q_t, q : BUFFER STD_LOGIC_VECTOR(3 DOWNTO 0));    
END tes_t0;


ARCHITECTURE teste OF tes_t0 IS
  TYPE sinais IS 
    RECORD ck, rst  : STD_LOGIC;
           d, q     : STD_LOGIC_VECTOR(3 DOWNTO 0);
    END RECORD;
 TYPE conjunto_sinais IS ARRAY (natural RANGE <>) OF sinais;
 CONSTANT vetores : conjunto_sinais :=
-- ck   rst   d     q      ck  rst   d      q      ck  rst    d     q
 (('U','1',"UUUU","UUUU"),('U','0',"UUUU","0000"),('1','1',"UUUU","0000"),  -- reset                     
  ('0','1',"ZZZZ","0000"),('0','1',"1010","0000"),('1','1',"1010","1010"),  -- armazena 1010                     
  ('0','1',"ZZZZ","1010"),('0','1',"0101","1010"),('1','1',"0101","0101"),  -- armazena 0101
  ('0','1',"ZZZZ","0101"),('0','1',"1100","0101"),('1','1',"1100","0011")); -- armazena 1100, 
                                                               --    \ 
 COMPONENT tes_st                                              --     \__ valor de teste errado   
   PORT (ck, rst : IN STD_LOGIC; d : IN STD_LOGIC_VECTOR(3 DOWNTO 0); 
         q : BUFFER STD_LOGIC_VECTOR(3 DOWNTO 0));
 END COMPONENT;

BEGIN
  operacao: PROCESS
    BEGIN
      FOR i IN 0 TO  vetores'LENGTH-1 LOOP
        ck_t   <= vetores(i).ck;  rst_t  <= vetores(i).rst;  
        d_t    <= vetores(i).d;   q_t    <= vetores(i).q;
      WAIT FOR 10 ns;
      END LOOP;
    WAIT;
  END PROCESS;
  
  iguais: POSTPONED PROCESS(q, q_t)  -- processo aguarda todas iteracoes pendentes
  BEGIN
   ASSERT q = q_t  -- (q=q_d) condicao correta, caso falso mensagem e' apresentada 
      REPORT "Valor da saida q difere do valor proposto" SEVERITY ERROR;
  END PROCESS;
     
  x1: tes_st PORT MAP(ck_t, rst_t, d_t, q);
END teste;