LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY tes_t1 IS
  PORT (ck_t, rst_t : BUFFER STD_LOGIC;
        d_t, q_t, q : BUFFER STD_LOGIC_VECTOR(3 DOWNTO 0));    
END tes_t1;

ARCHITECTURE teste OF tes_t1 IS
  TYPE sinais IS 
    RECORD ck, rst  : STD_LOGIC;
           d, q     : STD_LOGIC_VECTOR(3 DOWNTO 0);
    END RECORD;
 TYPE conjunto_sinais IS ARRAY (natural RANGE <>) OF sinais;
 CONSTANT vetores : conjunto_sinais :=
-- ck   rst   d     q      ck  rst   d      q      ck  rst    d     q
 (('U','1',"UUUU","UUUU"),('U','0',"UUUU","0000"),('1','1',"UUUU","0000"),  -- reset                     
  ('0','1',"ZZZZ","0000"),('0','1',"1010","0000"),('1','1',"1010","1010"),  -- armazena 1010                     
  ('0','1',"ZZZZ","1010"),('0','1',"0101","1010"),('1','1',"0101","0101"),  -- armazena 0101
  ('0','1',"ZZZZ","0101"),('0','1',"1100","0101"),('1','1',"1100","0011")); -- armazena 1100, 
                                                               --    \ 
 COMPONENT tes_st                                              --     \__ valor de teste errado   
   PORT (ck, rst : IN STD_LOGIC; d : IN STD_LOGIC_VECTOR(3 DOWNTO 0); 
         q : BUFFER STD_LOGIC_VECTOR(3 DOWNTO 0));
 END COMPONENT;

SIGNAL q_td : STD_LOGIC_VECTOR(3 DOWNTO 0);  -- empregado para atrasar de 1 delta o dado q_t

BEGIN
  operacao: PROCESS
    BEGIN
       FOR i IN 0 TO  vetores'LENGTH-1 LOOP
        ck_t   <= vetores(i).ck;  
        rst_t  <= vetores(i).rst;  
        d_t    <= vetores(i).d;   
        q_t    <= vetores(i).q;   
        WAIT FOR 10 ns;
      END LOOP;
    WAIT;
  END PROCESS;
  
   q_td <= q_t;     -- sincroniza valor "q_t" com "q", (q_t e' atrasado de 1 delta)
   ASSERT q = q_td  -- (q=q_td) condicao correta, caso falso mensagem e' apresentada 
      REPORT "Valor da saida q difere do proposto" SEVERITY ERROR;
     
  x1: tes_st PORT MAP(ck_t, rst_t, d_t, q);
END teste;