-- versao VHDL 1993
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE STD.TEXTIO.ALL;

ENTITY tes_t4 IS
  PORT (ck_t, rst_t : BUFFER STD_LOGIC;
        d_t, q_t, q : BUFFER STD_LOGIC_VECTOR(3 DOWNTO 0));    
END tes_t4;

ARCHITECTURE teste OF tes_t4 IS

FUNCTION para_std(dado_stg : STRING) RETURN STD_LOGIC_VECTOR IS
   VARIABLE dado_std : STD_LOGIC_VECTOR(dado_stg'LENGTH-1 DOWNTO 0);
BEGIN
  FOR i IN 1 TO dado_stg'LENGTH LOOP  -- valido para mesma ordem
    CASE dado_stg(i) IS                       
      WHEN '-'    => dado_std(i-1) := '-';  --  dado_stg:    
      WHEN 'Z'    => dado_std(i-1) := 'Z';  --  n     ...     1 
      WHEN 'W'    => dado_std(i-1) := 'W';  -- | |H|L|...|U|1|X|  string
      WHEN 'L'    => dado_std(i-1) := 'L';  --  \
      WHEN 'H'    => dado_std(i-1) := 'H';  --   \_ espaco 
      WHEN '0'    => dado_std(i-1) := '0';  -- 
      WHEN '1'    => dado_std(i-1) := '1';  --  retorna: dado_std        
      WHEN 'U'    => dado_std(i-1) := 'U';  -- n-1     ...    0
      WHEN OTHERS => dado_std(i-1) := 'X';  -- |X|H|L|...|U|1|X|  std_logic_vector
     END CASE;                              --   \           
   END LOOP;                                --    \_ espaco convertido para X
   RETURN dado_std;
END;

 COMPONENT tes_st
   PORT (ck, rst : IN STD_LOGIC; d : IN STD_LOGIC_VECTOR(3 DOWNTO 0); 
          q : BUFFER STD_LOGIC_VECTOR(3 DOWNTO 0));
 END COMPONENT;

BEGIN
  le: PROCESS     
    FILE     arquivo_rd  : TEXT OPEN READ_MODE IS "estim_t3.dat"; -- arquivo formato:
    VARIABLE linha       : LINE;                       -- | | | | | | | | | | | | | | | 
    VARIABLE ck_v, rst_v : STRING(2 DOWNTO 1);         --    U   1   U U U U   U U U U
    VARIABLE d_v,  q_v   : STRING(5 DOWNTO 1);         --    U   0   U U U U   0 0 0 0
  BEGIN                                                --    1   1   U U U U   0 0 0 0
    WHILE NOT ENDFILE(arquivo_rd) LOOP
     READLINE (arquivo_rd, linha);                     -- leitura de uma linha 
     READ (linha, ck_v);  ck_t  <= para_std(ck_v)(0);  -- leitura dos dados, remove espaco
     READ (linha, rst_v); rst_t <= para_std(rst_v)(0); --                      "
     READ (linha, d_v);   d_t   <= para_std(d_v)(3 DOWNTO 0); --               "
     READ (linha, q_v);   q_t   <= para_std(q_v)(3 DOWNTO 0); --               "        
     WAIT FOR 10 ns;                                   -- intervalo de tempo entre estimulos
    END LOOP;
    FILE_CLOSE(arquivo_rd);               
    WAIT;
  END PROCESS le;
  
  x1: tes_st PORT MAP(ck_t, rst_t, d_t, q);
END teste;