-- versao VHDL-1993
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY tes_t6 IS
  PORT (ck_t, rst_t : BUFFER STD_LOGIC;
        d_t, q_t, q : BUFFER STD_LOGIC_VECTOR(3 DOWNTO 0));    
END tes_t6;

ARCHITECTURE teste OF tes_t6 IS
 TYPE sinais IS  RECORD  d, q : STD_LOGIC_VECTOR(3 DOWNTO 0); 
 END RECORD;
 TYPE conjunto_sinais IS ARRAY (natural RANGE <>) OF sinais;
 CONSTANT vetores : conjunto_sinais :=
--    d     q         d      q        d     q
 (("UUUU","UUUU"),("UUUU","0000"),("UUUU","0000"),  -- reset                     
  ("ZZZZ","0000"),("1010","0000"),("1010","1010"),  -- armazena 1010                     
  ("ZZZZ","1010"),("0101","1010"),("0101","0101"),  -- armazena 0101
  ("ZZZZ","0101"),("1100","0101"),("1100","0011")); -- armazena 1100, 
                                                    --    \ 
 COMPONENT tes_st                                   --     \__ valor de teste errado   
   PORT (ck, rst : IN STD_LOGIC; d : IN STD_LOGIC_VECTOR(3 DOWNTO 0); 
         q : BUFFER STD_LOGIC_VECTOR(3 DOWNTO 0));
 END COMPONENT;

BEGIN
  operacao: PROCESS
    VARIABLE ck_v    : std_logic;
    VARIABLE sequencia_ck : BIT_VECTOR(2 DOWNTO 0) := "100"; -- sequencia de valores p/ ck
  BEGIN
    -- aplica primeiro conjunto de estimulos
    ck_t <= 'U';  rst_t <= '1';  d_t <= vetores(0).d;  q_t <= vetores(0).q; 
    WAIT FOR 10 ns;
    
    -- aplica segundo conjunto de estimulo
    ck_t <='U';   rst_t <= '0';  d_t <= vetores(1).d;  q_t   <= vetores(1).q;
    WAIT FOR 10 ns;
    
    -- aplica estimulos restantes, sinal de relogio gerado na linha 44
    rst_t <= '1' ;
    FOR i IN 2 TO  vetores'LENGTH-1 LOOP
      ck_t  <= To_StdULogic(sequencia_ck(2));  d_t <= vetores(i).d; q_t <= vetores(i).q;
      WAIT FOR 10 ns;
      sequencia_ck := sequencia_ck rol 1; -- circula p/ esquerda conjunto de valores 
     END LOOP;
    WAIT;
  END PROCESS;
  
  iguais: POSTPONED PROCESS(q, q_t)  -- processo aguarda todas iteracoes pendentes
  BEGIN
   ASSERT q = q_t  -- (q=q_d) condicao correta, caso falso mensagem e' apresentada 
      REPORT "Valor da saida q difere do valor proposto" SEVERITY ERROR;
  END PROCESS;
     
  x1: tes_st PORT MAP(ck_t, rst_t, d_t, q);
END teste;